/*
 * InformationTableController.h
 *
 *  Created on: 28.10.2009
 *      Author: stefan.detter
 */

#ifndef INFORMATIONTABLECONTROLLER_H_
#define INFORMATIONTABLECONTROLLER_H_

#include <QTableView>
#include <QPushButton>

#include <def.h>

class InformationTableModel;

class TreeItem;
class TagTreeControl;

class InformationTableController : public QObject
{
	Q_OBJECT
public:
	InformationTableController(TagTreeControl* ttc, QTableView* tableView, QPushButton* advancedButton, QObject* parent = 0);
	virtual ~InformationTableController();

public slots:
	void setInformationItem(const TreeItem* t);
	void advancedButtonClicked();

signals:
	void appendGlobalJob(JobType type, const QList<QVariant>& params);

private:
	QTableView* 			m_tableView;
	QPushButton* 			m_advancedButton;
    InformationTableModel* 	m_informationTableModel;
    TagTreeControl* 		m_ttc;

};

#endif /* INFORMATIONTABLECONTROLLER_H_ */
